
CREATE OR REPLACE FUNCTION createtable()
RETURNS VOID AS
$BODY$
BEGIN
    IF EXISTS (SELECT * FROM information_schema.columns     
                    WHERE table_name= 'est_prod_inf_divers' 
                      ) THEN
                         
        RAISE NOTICE 'Tabela já existe' ;
        
    ELSE
    CREATE TABLE public.est_prod_inf_divers (
		cd_emp numeric(6) NOT NULL DEFAULT 0,
		cd_prod numeric(10) NOT NULL DEFAULT 0,
		obrig_receita numeric NULL DEFAULT 0,
		uso_contin int4 NOT NULL DEFAULT 0,
		end_foto varchar(150) NOT NULL DEFAULT '',
		CONSTRAINT est_prod_inf_divers_pkey PRIMARY KEY (cd_emp, cd_prod),
		FOREIGN KEY (cd_emp, cd_prod) REFERENCES public.est_prod(cd_emp, cd_prod)
	)
	WITH (
		OIDS = FALSE
	)
		TABLESPACE pg_default;

		ALTER TABLE public.est_prod_inf_divers
			OWNER to postgres;     
				RAISE NOTICE 'Tabela criada com sucesso!';
	END IF; 
    
END;
-- fim bloco principal
$BODY$
LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION createtable()  OWNER TO postgres;
SELECT createtable();
DROP FUNCTION createtable();
